import { ChangeDetectorRef, OnInit } from '@angular/core';
import { AbstractControl, ControlValueAccessor, ValidationErrors, Validator } from '@angular/forms';
import { Cron } from '../../core/models/cron';
import { LicenseService } from '../../core/services/license.service';
import * as i0 from "@angular/core";
export declare const Days: any;
export declare const DayMap: any;
export declare const DisplayDays: any;
export declare const MonthWeeks: any;
export declare enum Months {
    January = 1,
    February = 2,
    March = 3,
    April = 4,
    May = 5,
    June = 6,
    July = 7,
    August = 8,
    September = 9,
    October = 10,
    November = 11,
    December = 12
}
export declare class CronEditorComponent implements OnInit, ControlValueAccessor, Validator {
    private changeDetectorRef;
    private licenseService;
    onChange: (_: any) => void;
    onTouched: () => void;
    cron: Cron;
    cronDescriber: string;
    activeTab: string;
    selectOptions: {
        months: number[];
        monthWeeks: number[];
        days: string[];
        minutes: number[];
        fullMinutes: number[];
        hours: number[];
        monthDays: number[];
        monthDaysWithLasts: string[];
        hourType: string[];
    };
    defaultHours: number;
    defaultHourType: string;
    defaultMinutes: number;
    state: {
        minutes: any;
        hourly: any;
        daily: any;
        weekly: any;
        monthly: any;
        yearly: any;
        advanced: any;
        validation: any;
        formRadioClass: any | null;
    };
    regenCallBacks: any;
    eventFreq: number;
    constructor(changeDetectorRef: ChangeDetectorRef, licenseService: LicenseService);
    validate(control: AbstractControl<any, any>): ValidationErrors | null;
    writeValue(value: any): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    ngOnInit(): void;
    setActiveTab(tab: string): void;
    setInitCron(cron: Cron): void;
    private setAdvancedTab;
    private checkIsAdvanced;
    private regenerateMinutes;
    private regenerateHourly;
    private regenerateDaily;
    private regenerateWeekly;
    private regenerateMonthly;
    private regenerateYearly;
    regenerateCron(regenerate?: boolean): void;
    private hourToCron;
    dayDisplay(day: string): string;
    monthWeekDisplay(monthWeekNumber: number): string;
    monthDisplay(month: number): string;
    private getHourType;
    monthDayDisplay(month: string): string;
    private getOrdinalSuffix;
    cronStringToJson(cronSeven: string): {
        minute: string;
        hour: string;
        day_of_month: string;
        month_of_year: string;
        day_of_week: string;
        timezone: string;
    };
    cronJsonToString(cronJson: Cron): string;
    _validate(cron: string): void;
    getRange(startFrom: number, until: number): number[];
    static ɵfac: i0.ɵɵFactoryDeclaration<CronEditorComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<CronEditorComponent, "xf-cron-editor", never, {}, {}, never, never, false, never>;
}
