import { ChangeDetectorRef, ElementRef, OnInit, QueryList } from '@angular/core';
import { ControlValueAccessor, FormBuilder, FormGroup } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { ApiService } from '../../core/services/api.service';
import { EntityService } from '../../core/services/entity.service';
import * as i0 from "@angular/core";
export declare class TagsInputComponent implements ControlValueAccessor, OnInit {
    searchInput: ElementRef;
    dropdown: NgbDropdown;
    dropdownItems: QueryList<ElementRef>;
    formGroup: FormGroup;
    loading: boolean;
    placeholder: string;
    size: string;
    tagsBaseUrl: string;
    filteredTags: string[];
    apiService: ApiService;
    entityService: EntityService;
    changeDetectorRef: ChangeDetectorRef;
    private onChange?;
    private onTouched?;
    constructor(formBuilder: FormBuilder);
    tags: string[];
    registerOnChange(fn: (value: any) => void): void;
    registerOnTouched(fn: () => void): void;
    writeValue(value: any): void;
    ngOnInit(): void;
    applySearch(searchText: string): import("rxjs").Observable<void>;
    onTab(): void;
    onEnter(event: Event): void;
    addTag(tag: string): void;
    focusOnSearchInput(): void;
    focusOnItem(index: number): void;
    onBackspace(): void;
    removeTag(tag: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TagsInputComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TagsInputComponent, "xf-tags-input[tagsBaseUrl]", never, { "placeholder": { "alias": "placeholder"; "required": false; }; "size": { "alias": "size"; "required": false; }; "tagsBaseUrl": { "alias": "tagsBaseUrl"; "required": false; }; }, {}, never, never, true, never>;
}
