import { HttpClient } from '@angular/common/http';
import { ChangeDetectorRef } from '@angular/core';
import { ControlValueAccessor, FormBuilder, FormGroup } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { Observable } from 'rxjs';
import { Person } from '../../core/models/person';
import { Team } from '../../core/models/team';
import * as i0 from "@angular/core";
export declare class UserMultiselectComponent implements ControlValueAccessor {
    private http;
    private changeDetectorRef;
    private formBuilder;
    dropdownSettings: IDropdownSettings;
    includeTeams: boolean;
    excludeIris: string[];
    userTeamList: (Person | Team)[];
    formGroup: FormGroup;
    value: {
        display: string;
        uuid: string;
    }[];
    onChange: (_: any) => void;
    onTouched: () => void;
    constructor(http: HttpClient, changeDetectorRef: ChangeDetectorRef, formBuilder: FormBuilder);
    writeValue(value: any): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    ngOnChanges(): void;
    loadUsersAndTeams(): void;
    ngOnInit(): void;
    loadUsers(): Observable<Person[]>;
    loadTeams(): Observable<Team[]>;
    get getItems(): import("lodash").Dictionary<Person | Team>;
    static ɵfac: i0.ɵɵFactoryDeclaration<UserMultiselectComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<UserMultiselectComponent, "xf-user-multiselect[formControlName]", never, { "includeTeams": { "alias": "includeTeams"; "required": false; }; "excludeIris": { "alias": "excludeIris"; "required": false; }; }, {}, never, never, false, never>;
}
