import { HttpContextToken } from "@angular/common/http";
export declare enum TOKEN {
    ACCESS_KEY = "access.token",
    REFRESH_KEY = "refresh.token",
    RESTRICTED_KEY = "restricted.token"
}
export declare enum MMD {
    MODEL_METADATAS_KEY = "model_metadatas",
    STAGING_METADATAS_KEY = "staging_model_metadatas",
    STAGING_ATTRIBUTE_METADATA_KEY = "attribute_metadatas",
    SYSTEM_MODEL_METADATAS_KEY = "system_model_metadatas",
    VIEW_TEMPLATES_KEY = "view_templates",
    WIDGET_CONFIG_KEY = "widget_configs"
}
export declare const RESERVED_KEYWORDS: {
    PLAYBOOKS: string[];
    MMD_FIELDS: string[];
};
export declare enum VIEW_TEMPLATES {
    GRID_COLUMNS = "grid_columns",
    TYPE = "SystemViewTemplate",
    CACHE_PREFIX = "views.",
    VIEW_API_BASE = "/api/views/1/",
    SYSTEM_VIEW_TEMPLATES_MODEL = "system_view_templates"
}
export declare enum API {
    API = "api/",
    BASE = "api/3/",
    API_APPMANAGER = "api/appmanager/",
    DELETE_WITH_QUERY = "api/3/delete-with-query/",
    BULK_UPDATE = "api/3/update/",
    API_3_BASE = "api/3/",
    INSERT = "api/3/insert/",
    QUERY = "api/query/",
    SYSTEM_MODULES = "api/system/fixtures",
    CURRENT_ACTOR = "actors/current",
    AUTH = "api/auth/",
    DAS = "auth/",
    WEBSOCKET = "websocket/cyops-websocket",
    INTEGRATIONS = "api/integration/",
    INTEGRATION_CONFIGURATION = "api/integration/configuration/",
    WORKFLOW_ACTION = "xf/api/workflows/actions",
    PUBLIC = "api/public/",
    RULE = "api/rule/",
    WORKFLOW = "api/workflow/",
    WORKFLOW_GROUPS = "workflow_groups/",
    WORKFLOW_STEPS = "workflow_steps/",
    WORKFLOWS = "workflows/",
    USERS = "api/auth/users/",
    TEAMS = "api/auth/teams/",
    QUERY_PART = "query/",
    SEALAB = "api/workflow/",
    TEMP_WORKFLOWS = "wf/api/",
    EXPRESSIONS = "api/workflow/expressions/",
    LOGOUT = "token/logout/",
    SCHEDULE = "api/workflow/schedules/",
    AUDIT = "api/audit/",
    PORTER = "api/appmanager/",
    RULE_ENGINE = "api/rule-engine/"
}
export declare const OPERATOR_MAPPINGS: Record<string, string>;
export declare const ALL_RECORDS_SIZE = 2147483647;
export declare const DEFAULT_NEW_MODULE_PERMISSIONS: {
    create: boolean;
    read: boolean;
    update: boolean;
    delete: boolean;
    execute: boolean;
    fields: {};
};
export declare const DEFAULT_REPO_URL = "https://@product_yum_server@/";
export declare enum STORAGE_KEYS {
    LOCAL_STORAGE_PREFIX = "xf.",
    LOCAL_STORAGE_PERSIST_PREFIX = "persist:",
    CURRENT_USER = "current_user",
    CURRENT_PERMISSIONS = "current_user.roles",
    SETTINGS_HISTORY = "settings_history",
    SETTINGS_ACCOUNT_CONFIG = "account_configuration",
    SYSTEM_SETTINGS = "system_settings",
    USER_PREFERENCES = "user_preferences",
    AUDIT_PURGE_SETTINGS = "audit_purge_settings",
    WF_PURGE_SETTINGS = "wf_purge_settings",
    LICENSE_DETAILS = "license_details"
}
export declare enum AUTH {
    TOKEN = "TOKEN"
}
export declare enum THEMES {
    DEFAULT = "dark"
}
export declare enum FIXED_MODULE {
    XF_QUEUES = "xf_queues",
    SHIFTS = "shifts",
    APPROVAL = "approvals",
    APPLICATION = "application",
    PLAYBOOK = "playbooks",
    PLAYBOOK_VERSIONS = "versions",
    PLAYBOOK_STEPS = "playbook-steps",
    EVENTS = "events",
    PLAYBOOK_COLLECTION = "playbook-collections",
    PEOPLE = "people",
    COMMENTS = "comments",
    TEAMS = "teams",
    ROLES = "roles",
    ROLE_SERVICES = "services",
    ROLE_ENTITIES = "entities",
    ROLE_PERMISSIONS = "permissions",
    USERS = "users",
    AUDIT_LOGS = "audit-logs",
    APPLIANCES = "appliances",
    SECURITY = "security",
    EXPORT_TEMPLATES = "export-templates",
    EXPORT_JOBS = "export-jobs",
    IMPORT_JOBS = "import-jobs",
    FILES = "files",
    PICKLIST_NAMES = "picklist_names",
    PICKLISTS = "picklists",
    LEGACY_SYSTEM_VIEW_TEMPLATE = "system_view_templates",
    WIDGET_METADATAS = "widget_metadatas",
    DYNAMIC_CONTENT = "dynamic_content",
    SETTINGS_CATEGORIES = "settings_categories",
    SETTINGS_LINKS = "settings_links",
    SETTINGS_PAGES = "settings_pages",
    SCHEDULES = "schedules",
    VIEW_TEMPLATES = "view-templates",
    WIDGET_CONFIGS = "widget-configs",
    AGENTS = "agents",
    WORKFLOW_LOGS = "workflow_logs",
    CONNECTORS = "connectors",
    GLOBAL_VARIABLES = "global-variables",
    RULE = "rules",
    CHANNEL = "channels",
    PENDING_NOTIFICATION = "pending-notification",
    SYSTEM_NOTIFICATION = "system-notification",
    SOLUTION_PACK = "solution-packs",
    WIDGETS = "widgets",
    PLAYBOOK_EXECUTION_LOGS = "playbook-execution-logs",
    CONNECTOR_CONFIGURATIONS = "connector-configurations",
    REFERENCE_BLOCKS = "reference-blocks",
    CONTENT_HUB = "contenthub",
    DASHBOARD = "dashboard",
    DELIVERY_RULES = "delivery-rules",
    NOTIFICATIONS = "notifications",
    EXPRESSIONS = "expressions",
    APPLICATION_CONFIGURATION = "application-configuration",
    TAGS = "tags",
    SYSTEM_SETTINGS = "system-settings",
    API_KEYS = "apikeys"
}
export declare const MAX_PLAYBOOK_RECORDS = 250;
export declare const DEFAULT_GRID_ROWS = 20;
export declare const DEFAULT_LOOKUP_RECORDS = 30;
export declare const DEFAULT_CACHE_BLOCK_SIZE = 30;
export declare const MAX_TEXT_LENGTH = 10485761;
export declare const MIN_NUMBER_LIMIT = -2147483648;
export declare const SORT_ORDER: {
    value: string;
    label: string;
}[];
export declare enum CS_USER_TYPE {
    CS_USERTYPE_SECADMIN = 1,
    CS_USERTYPE_USER = 2,
    CS_USERTYPE_APPLIANCE = 3,
    CS_USERTYPE_MSSP = 4,
    CS_USERTYPE_NO_IDLE = 5,
    CS_USERTYPE_SAML = 6,
    CS_USERTYPE_LDAP = 7,
    CS_USERTYPE_RADIUS = 8
}
export declare enum USER_ACCESS_TYPE {
    NAMED = "Named",
    CONCURRENT = "Concurrent"
}
export declare const BRANDING_FALLBACK: {
    light: {
        largeLogo: string;
    };
    dark: {
        largeLogo: string;
    };
    favicon: string;
};
export declare const CONTENTHUB: any;
export declare const CONFIGURATION_LABELS: any;
export declare const CONFIG_IMPORT_ORDER: string[];
export declare const APP_SETTINGS: {
    name: string;
    title: string;
}[];
export declare const LANGUAGE_DATA: {
    id: string;
    label: string;
}[];
export declare const REGEX: {
    ATTACHMENT_IRI: RegExp;
    FILE_IRI: RegExp;
    XSS_SVG_FILTER: RegExp;
    HTML_ENTITIES_XSS_SVG_FILTER: RegExp;
    ALPHA_NUMERIC_UNDERSCORE: RegExp;
    ALPHA_NUMERIC_UNDERSCORE_SPACE: RegExp;
    PB_STEP_NAME: RegExp;
};
export declare const COMMENT_TYPES: {
    ACTION_LOG: string;
    COMMENT: string;
};
export declare const UUID_REGEX: RegExp;
export declare const JINJA_REGEX: RegExp;
export declare const TOKEN_STORAGE_KEY = "token";
export declare const TITLE_POSTFIX = "FortiSOAR Cloud Platform";
export declare const TITLE_POSTFIX_ABBR = "FCP";
export declare const AGENT_CONFIG_HEALTH: {
    in_progress: string;
    complete_on_message_exchange: string;
    remote_node_connected: string;
    missed_heartbeats: string;
    failed_on_message_exchange: string;
    message_exchange_unreachable: string;
    remote_node_unreachable: string;
};
export declare enum CONNECTOR_STATUS {
    INSTALLED = "installed"
}
export declare const CHANNEL_UUIDS: {
    IN_APP: string;
    EMAIL: string;
    QUEUE: string;
    RESUME_CONDITIONAL_PB_STEP: string;
    ON_PLAYBOOK_FAILURE: string;
};
export declare const POLL_INTERVAL = 5000;
export declare enum PERMISSION {
    READ = "read",
    CREATE = "create",
    UPDATE = "update",
    DELETE = "delete",
    EXECUTE = "execute",
    DEBUG = "debug",
    INSTALL = "install",
    RETRY = "retry"
}
export declare const ERROR_OBJECTS: {
    404: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
        description: string;
    };
    403: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
        description: string;
    };
    500: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
    };
    501: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
    };
    502: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
        description: string;
    };
    503: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
    };
    504: {
        code: number;
        icon: string;
        error: string;
        errorText: string;
        description: string;
    };
};
export declare const IGNORE_ERRORS: HttpContextToken<boolean>;
export declare const MODULE_MAPPING: {
    manualinput: string;
    playbook_log: string;
};
export declare const DEFAULT_SCHEDULE_TASKS: {
    AUDIT: {
        SETTING: string;
        TASK: string;
    };
    PLAYBOOK: {
        SETTING: string;
        TASK: string;
    };
    SYSTEM_NOTOFICATIONS: {
        SETTING: string;
        TASK: string;
    };
    FAILURE_NOTOFICATIONS: {
        SETTING: string;
        TASK: string;
    };
};
export declare const MASK_KEY_FORMAT = "xxxxxxxxxxxxxxxxxxxxxxxxxxxx";
export declare const cloudURL = "https://platform.fortisoar.forticloud.com/";
