import { Completion, CompletionSection } from "@codemirror/autocomplete";
export interface CompletionItem extends Completion {
    value: string;
    dataTypes: ('list' | 'dict' | 'string' | 'number' | 'boolean' | 'any')[];
    function?: {
        inputs?: FunctionInput[];
        type: ('method' | 'filter' | 'test');
    };
    outputType: 'list' | 'dict' | 'string' | 'number' | 'void' | 'boolean' | 'any';
    subItems?: CompletionItem[];
    sectionTitle: string;
    section: CompletionSection;
    includesBrackets?: boolean;
    hiddenByDefault?: boolean;
    parent?: CompletionItem;
}
export interface FunctionInput {
    label: 'string';
    optional?: boolean;
    type: 'list' | 'dict' | 'string' | 'number' | 'any';
}
