import { Field } from "./field";
export declare class Entity {
    id: number | undefined;
    uuid: string | undefined;
    type: string;
    module: string;
    displayName: string;
    descriptions: {
        singular: string;
        plural: string;
    };
    moduleDescription?: string;
    defaultSort: [];
    uniqueConstraint: [];
    display: string;
    attributes: Field[];
    values: {
        [fieldName: string]: any;
    };
    ownable: boolean;
    primaryKey: string;
    userOwnable: boolean;
    trackable: boolean;
    softDeleteable: boolean;
    queueable: boolean;
    indexable: boolean;
    peerReplicable: boolean;
    system: boolean;
    tableName: string;
    taggable: boolean;
    conditionalOwnable: boolean;
    writeable: boolean;
    bulkAction: {
        allow: boolean;
        buttonClass: string;
        buttonIcon: string;
        buttonText: string;
    };
    parentType: string;
    baseUrl: string;
    constructor(type: string);
    get fields(): Entity.FieldMap;
    set fields(_fields: Entity.FieldMap);
    get relationships(): Field[];
    get iri(): string;
    evaluateAllFields(): void;
    get title(): string;
    getFormFields(): Field[];
}
export declare namespace Entity {
    interface FieldMap {
        [fieldName: string]: Field;
    }
    interface ValueMap {
        [fieldName: string]: any;
    }
}
