import { Type } from "@angular/core";
import { IFilterAngularComp, IFloatingFilterAngularComp } from "ag-grid-angular";
import { ColDef } from "ag-grid-community";
import { AbstractFieldComponent } from "../../form-fields/field-renderers/built-ins/abstract-field.component";
import { AbstractViewComponent } from "../../form-fields/field-renderers/built-ins/abstract-view.component";
import { Filter } from "../../query-filters/models/filter";
import { Operator } from "../../query-filters/models/operator";
import { QuerySort } from "../../query-filters/models/query";
import { SearchableItem } from "../../components/searchable-dropdown/searchable-item";
export declare class Field {
    name: string;
    fieldComponent: Type<AbstractFieldComponent>;
    viewComponent: Type<AbstractViewComponent>;
    gridFilterComponent?: Type<IFilterAngularComp>;
    gridFloatingFilterComponent?: Type<IFloatingFilterAngularComp>;
    defaultColDef?: ColDef;
    formType: Field.BuiltInType | string;
    defaultValue: string | number | object;
    blankDisplay: string | number | object;
    private _descriptions;
    _dataSource: {
        model: string;
        query: any;
        displayConditions?: any;
        baseURL?: string;
        requestType?: 'GET' | 'POST';
    };
    dataSourceFilters?: any;
    bulkAction?: any;
    title: string;
    type: string;
    encrypted: boolean;
    gridColumn: boolean;
    orderIndex: number;
    peerReplicable: boolean;
    htmlEscape: boolean;
    inversedField: string | null;
    ownsRelationship: boolean;
    recommend: boolean;
    searchable: boolean;
    system: boolean;
    tooltip: string;
    subtitle?: string;
    validation?: any;
    fieldOptions?: any;
    private _visibility;
    get visibility(): any | boolean;
    set visibility(value: any | boolean);
    writeable: boolean;
    visible: boolean;
    required: boolean;
    isFormField: boolean;
    isRelationship: boolean;
    editable?: boolean;
    unique?: boolean;
    model?: string;
    uuid: string | undefined;
    displayTemplate: string;
    defaultSort?: [];
    readOnly: boolean;
    trackable: boolean;
    placeholder: string;
    OPERATOR_KEY: string;
    fieldContainerClass: string;
    orphanRemoval: boolean;
    getFlatValue(value: any, operator: Operator): any;
    getViewValue(value: any): any;
    protected static listOperators: Operator[];
    protected static nullOperator: Operator[];
    protected static equalOperators: Operator[];
    protected static greaterThanLessThanOperators: Operator[];
    protected static numericGreaterThanLessThanOperators: Operator[];
    protected static isChangedOperators: Operator[];
    static operators: Operator[];
    getOperator(operatorId: string): Operator | undefined;
    get operators(): Operator[];
    allowJinjaToggle: boolean;
    alwaysJinja: boolean;
    filter: Type<Filter>;
    display?: string;
    data?: any;
    params?: any;
    mapping: Record<string, string>;
    alwaysEditMode: boolean;
    constructor(name: string, formType: Field.BuiltInType | string);
    get descriptions(): {
        singular: string;
    };
    set descriptions(value: {
        singular: string;
    });
    get dataSource(): {
        model: string;
        query: any;
        baseURL?: string;
        options?: SelectOption[];
        requestType?: 'GET' | 'POST';
    };
    set dataSource(value: {
        model: string;
        query: any;
        displayConditions?: any;
        baseURL?: string;
        requestType?: 'GET' | 'POST';
    });
    setMode(mode: 'add' | 'archived'): void;
    protected static evaluateIsInList(field: Field, value: any): boolean;
    protected static evaluateIsNotInList(field: Field, value: any): boolean;
    protected static evaluateIsNull(field: Field, value: any): boolean;
    protected static evaluateEqual(field: Field, value: any): boolean;
    protected static evaluateNotEqual(field: Field, value: any): boolean;
    protected static evaluateBefore(field: Field, value: any): boolean;
    protected static evaluateOnOrBefore(field: Field, value: any): boolean;
    protected static evaluateAfter(field: Field, value: any): boolean;
    protected static evaluateOnOrAfter(field: Field, value: any): boolean;
    protected static evaluateIsChanged(field: Field, value: any): boolean;
    asSearchableItem(): SearchableItem;
    buildSort(order: 'ASC' | 'DESC' | ''): QuerySort[];
    getURLQueryValue(value: any, operator: Operator): any;
    getFieldLength(): {
        minlength: number;
        maxlength: number;
    };
}
export declare namespace Field {
    enum BuiltInType {
        TEXT = "text",
        PASSWORD = "password",
        INTEGER = "integer",
        DECIMAL = "decimal",
        CHECKBOX = "checkbox",
        EMAIL = "email",
        DATETIME = "datetime",
        LOOKUP = "lookup",
        MULTISELECT_PICKLIST = "multiselectpicklist",
        PICKLIST = "picklist",
        MANY_TO_MANY = "manyToMany",
        ONE_TO_MANY = "oneToMany",
        FILE = "file",
        JSON = "json",
        JINJA = "jinja",
        ARRAY = "array",
        PHONE = "phone",
        DOMAIN = "domain",
        FILEHASH = "fileHash",
        IPv4 = "ipv4",
        IPv6 = "ipv6",
        RICHTEXTHTML = "html",
        RICHTEXTMARKDOWN = "richtext",
        TEXTAREA = "textarea",
        URL = "url",
        TAGS = "tags",
        SELECT = "select",
        MULTISELECT = "multiselect",
        RADIO = "radio",
        TOGGLE = "toggle",
        MULTISELECTCHECKBOXDROPDOWN = "multiSelectCheckboxDropdown",
        TOGGLEDROPDOWN = "toggleDropdown",
        CERTIFICATE = "certificate"
    }
}
export type SelectOption = {
    value: string;
    label: string;
};
