import { RecordTypeRule } from "./record-type-rule";
import { Entity } from "./entity";
export declare class Rule {
    name: string;
    recordTypeRules: RecordTypeRule[];
    recordTypes: string[];
    uuid?: string;
    entityType?: string;
    eventType?: string;
    triggerCondition?: any;
    isActive: boolean;
    eventSource: string;
    modules: string;
    entity?: Entity;
    actions: RuleAction[];
    constructor(name: string);
    get iri(): string;
    asSaved(): {
        uuid: string | undefined;
        name: string;
        entity_type: string | undefined;
        event_type: string | undefined;
        trigger_condition: any;
        actions: RuleAction[];
        is_active: boolean;
        event_source: string;
    };
}
export interface RuleAction {
    channel_uuid: string;
    enabled: boolean;
    params: any;
    type: string;
}
