import { HttpClient } from '@angular/common/http';
import { Type } from '@angular/core';
import { Observable } from 'rxjs';
import { Entity } from '../models/entity';
import { HydraResponse } from '../models/hydra-response';
import * as i0 from "@angular/core";
export declare class ApiService {
    http: HttpClient;
    getList(entity: Entity, type?: Type<any>, params?: any): Observable<any>;
    getRecord(entity: Entity, uuid: string, type?: Type<any>, ignoreErrors?: boolean): Observable<any>;
    query(entity: Entity, queryBody: Object | null, params?: any, ignoreErrors?: boolean): Observable<HydraResponse>;
    updateRecord(entity: Entity, uuid: string, payload: Record<string, any>): Observable<any>;
    createRecord(entity: Entity, payload: Record<string, any>): Observable<any>;
    upsertRecord(entity: Entity, payload: Record<string, any>): Observable<any>;
    deleteRecord(entity: Entity, uuid: string, ignoreErrors?: boolean): Observable<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<ApiService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ApiService>;
}
