import { Observable } from 'rxjs';
import { Query } from '../../query-filters/models/query';
import { Entity } from '../models/entity';
import { EntityChange } from '../models/entity-change';
import { EntityService } from './entity.service';
import { WebsocketService } from './websocket.service';
import * as i0 from "@angular/core";
export declare class DataProviderService {
    private entityService;
    private websocketService;
    private topics$;
    private websocketTopics$;
    constructor(entityService: EntityService, websocketService: WebsocketService);
    clear(): void;
    observe(entity: Entity, uuid?: string, relatedField?: string, queryObject?: Query): Observable<EntityChange>;
    save(entityChange: EntityChange): Observable<Entity>;
    private handleWebsocketUpdates;
    private getData;
    static ɵfac: i0.ɵɵFactoryDeclaration<DataProviderService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<DataProviderService>;
}
