import { ChangeDetectorRef, DoCheck, ElementRef, EventEmitter, OnInit, SimpleChanges } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { Subscription } from 'rxjs';
import { Entity } from '../../../../core/models/entity';
import { Field } from '../../../../core/models/field';
import { UtilityService } from '../../../../core/services/utility.service';
import { FieldOptions } from '../../../models/field-options';
import { FormFieldComponent } from '../form-field/form-field.component';
import * as i0 from "@angular/core";
export declare class EditableFieldComponent implements OnInit, DoCheck {
    private utilityService;
    private formBuilder;
    private elementRef;
    private changeDetectorRef;
    editMode: boolean;
    readOnly: boolean;
    showLabel: boolean;
    size?: string;
    showInline: boolean;
    disableSubmitOnEnter: boolean;
    autoFocus: boolean;
    editModeChange: EventEmitter<boolean>;
    valueChange: EventEmitter<any>;
    onSubmit: EventEmitter<void>;
    field: Field;
    value: any;
    entity: Entity;
    formField: FormFieldComponent;
    subscription?: Subscription;
    fieldOptions?: FieldOptions;
    formGroup?: FormGroup;
    fieldClass?: string;
    oldValueIri?: string;
    constructor(utilityService: UtilityService, formBuilder: FormBuilder, elementRef: ElementRef, changeDetectorRef: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    subscribe(): void;
    unsubscribe(): void;
    toggleEditMode(): void;
    handleClickEvent(event: Event): void;
    onSave(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<EditableFieldComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<EditableFieldComponent, "xf-editable-field", never, { "editMode": { "alias": "editMode"; "required": false; }; "readOnly": { "alias": "readOnly"; "required": false; }; "showLabel": { "alias": "showLabel"; "required": false; }; "size": { "alias": "size"; "required": false; }; "showInline": { "alias": "showInline"; "required": false; }; "disableSubmitOnEnter": { "alias": "disableSubmitOnEnter"; "required": false; }; "autoFocus": { "alias": "autoFocus"; "required": false; }; "field": { "alias": "field"; "required": false; }; "value": { "alias": "value"; "required": false; }; "fieldOptions": { "alias": "fieldOptions"; "required": false; }; "fieldClass": { "alias": "fieldClass"; "required": false; }; }, { "editModeChange": "editModeChange"; "valueChange": "valueChange"; "onSubmit": "onSubmit"; }, never, never, false, never>;
}
