import { ChangeDetectorRef, EventEmitter } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { GridsterConfig } from 'angular-gridster2';
import { BehaviorSubject, Observable, Subject } from 'rxjs';
import { Entity, EntityService, UtilityService } from "shared";
import { ViewLayoutItem } from '../../models/view-layout-item';
import { ViewTemplate } from '../../models/view-template';
import { ViewTemplateContext } from '../../models/view-template-context';
import { Widget } from '../../models/widget';
import { WidgetConfig } from '../../models/widget-config';
import { WidgetService } from '../../widgets/widget.service';
import { ViewTemplateService } from '../view-template.service';
import * as i0 from "@angular/core";
export declare abstract class AbstractLayoutItemComponent {
    changeDetectorRef: ChangeDetectorRef;
    ngbModalService: NgbModal;
    entityService: EntityService;
    widgetService: WidgetService;
    utilityService: UtilityService;
    viewTemplateService: ViewTemplateService;
    layoutItem: ViewLayoutItem;
    mode: string | null;
    viewTemplate: ViewTemplate | null | undefined;
    context: ViewTemplateContext;
    selectedWidget: Widget | ViewLayoutItem.Tabs;
    widgetSelection$: BehaviorSubject<Widget | ViewLayoutItem.Tabs>;
    gridsterConfig: GridsterConfig;
    layoutItemChange: EventEmitter<ViewLayoutItem>;
    entity: Entity;
    gridsterHeight: number;
    fixedGridItemHeight: number;
    onUpdateGridsterHeight: Subject<{
        config: any;
        id: string;
    }>;
    constructor(changeDetectorRef: ChangeDetectorRef, ngbModalService: NgbModal, entityService: EntityService, widgetService: WidgetService, utilityService: UtilityService, viewTemplateService: ViewTemplateService);
    ngOnInit(): void;
    addWidget(): Observable<WidgetConfig>;
    private gridsterResize;
    static ɵfac: i0.ɵɵFactoryDeclaration<AbstractLayoutItemComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<AbstractLayoutItemComponent, "xf-abstract-layout-item", never, { "layoutItem": { "alias": "layoutItem"; "required": false; }; "mode": { "alias": "mode"; "required": false; }; "viewTemplate": { "alias": "viewTemplate"; "required": false; }; "context": { "alias": "context"; "required": false; }; "selectedWidget": { "alias": "selectedWidget"; "required": false; }; "widgetSelection$": { "alias": "widgetSelection$"; "required": false; }; "gridsterConfig": { "alias": "gridsterConfig"; "required": false; }; }, { "layoutItemChange": "layoutItemChange"; }, never, never, false, never>;
}
