import { HttpClient } from '@angular/common/http';
import { Type } from '@angular/core';
import { Observable } from 'rxjs';
import { DynamicContent, HeaderService, StorageService } from "shared";
import { Widget } from '../models/widget';
import { WidgetConfig } from '../models/widget-config';
import * as i0 from "@angular/core";
export declare class WidgetService {
    private http;
    builtInWidgets: Record<string, Widget>;
    builtInWidgetConfigs: {
        [key: string]: Type<WidgetConfig>;
    };
    private widgets;
    constructor(http: HttpClient);
    headerService: HeaderService;
    localStorage: StorageService;
    loadWidget(name: string, force?: boolean): Observable<Widget>;
    private getWidgetById;
    getWidget(name: string, version: string | null): Observable<Object>;
    loadDynamicContent(name: string, type: string): Observable<DynamicContent | null>;
    loadWidgets(name: string): Observable<Record<string, Widget>>;
    getRemoteConfig(widget: Widget): Observable<Type<WidgetConfig>>;
    castAsWidgetConfig(object: any, widget: Widget): Observable<WidgetConfig>;
    static ɵfac: i0.ɵɵFactoryDeclaration<WidgetService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<WidgetService>;
}
